<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_ControllerPublic_Forum extends XFCP_sonnbStopSpamHere_ControllerPublic_Forum
{  
    public function actionAddThread()
    {      
        $message = $this->getHelper('Editor')->getMessageText('message', $this->_input);
        $forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
        $sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
        
        if ($sshModel->_hasLinkCheck('thread') && 
        		(empty($sshModel->linkCheckNodes) || in_array($forumId, $sshModel->linkCheckNodes)))
        {
            $return = $sshModel->checkLink(sonnbStopSpamHere_Model_SSH::TYPE_THREAD, 0, $message);

            if ($return)
            {
                $dwData = array(
                            'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_LINK,
                            'data' => $return['data']
                        );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError('link', array(
                            'post'=> $sshModel->options->sonnbStopSpamHere_linkDisabledPostCount, 
                            'day'=> $sshModel->options->sonnbStopSpamHere_linkDisabledJoinDate
                        ));
                        break;
                    case 'moderate':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_MODERATE] = $dwData;
                        break;
                    case 'pc':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_CONVERSATION] = $dwData;
                        break;
                    case 'report':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_REPORT] = $dwData;
                        break;
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        if ($sshModel->_hasKeywordCheck('thread') && 
        		(empty($sshModel->keywordCheckNodes) || in_array($forumId, $sshModel->keywordCheckNodes)))
        {
            $return = $sshModel->checkKeyword(sonnbStopSpamHere_Model_SSH::TYPE_THREAD, 0, $message);

            if ($return)
            {
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_KEYWORD,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError('keyword', array(
                            'keywords'=>implode('","', $return['data']['matches'])
                        ));
                        break;
                    case 'moderate':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_MODERATE] = $dwData;
                        break;
                    case 'pc':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_CONVERSATION] = $dwData;
                        break;
                    case 'report':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_REPORT] = $dwData;
                        break;
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
	
        if ($sshModel->_hasAkismetCheck('thread') && 
        		(empty($sshModel->akismetCheckNodes) || in_array($forumId, $sshModel->akismetCheckNodes)))
        {
            $return = $sshModel->checkAkismet(sonnbStopSpamHere_Model_SSH::TYPE_THREAD, 0, $message);
            
            if ($return)
            {
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_AKISMET,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError();
                        break;
                    case 'moderate':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_MODERATE] = $dwData;
                        break;
                    case 'pc':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_CONVERSATION] = $dwData;
                        break;
                    case 'report':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_REPORT] = $dwData;
                        break;
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        return parent::actionAddThread();
    }
    
    public function throwError($type='default', $data = array())
    {
        $params = array();
        switch ($type)
        {
            case 'link':
                $params = $data;
                if (empty($params['post']) && !empty($params['day']))
                {
                    $type .= '_day';
                }
                elseif (empty($params['day']) && !empty($params['post']))
                {
                    $type .= '_post';
                }
                elseif (empty($params['day']) && empty($params['post']))
                {
                    $type .= '_no_reason';
                }
                break;
            case 'keyword':
                $params = $data;
                break;
            case 'default':
            default:
                $params = array('contactUrl' => sonnbStopSpamHere_Model_Log::getContactUrl());
                break;
        }
        
        throw $this->responseException(
                $this->responseError(
                        new XenForo_Phrase(
                                'sonnbStopSpamHere_post_stop_message_'.$type,
                                $params
                            )
                        , 403)
                );
    }

}